/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Ch34xSerialDriver
implements UsbSerialDriver {
    private static final String TAG = Ch34xSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final UsbSerialPort mPort;

    public Ch34xSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPort = new Ch340SerialPort(this.mDevice, 0);
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return Collections.singletonList(this.mPort);
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(6790, new int[]{29987});
        return supportedDevices;
    }

    public class Ch340SerialPort
    extends CommonUsbSerialPort {
        private static final int USB_TIMEOUT_MILLIS = 5000;
        private final int DEFAULT_BAUD_RATE = 9600;
        private boolean dtr;
        private boolean rts;
        private UsbEndpoint mReadEndpoint;
        private UsbEndpoint mWriteEndpoint;

        public Ch340SerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.DEFAULT_BAUD_RATE = 9600;
            this.dtr = false;
            this.rts = false;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return Ch34xSerialDriver.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void open(UsbDeviceConnection connection) throws IOException {
            if (this.mConnection != null) {
                throw new IOException("Already opened.");
            }
            this.mConnection = connection;
            boolean opened = false;
            try {
                for (int i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                    UsbInterface usbIface = this.mDevice.getInterface(i);
                    if (this.mConnection.claimInterface(usbIface, true)) {
                        Log.d((String)TAG, (String)("claimInterface " + i + " SUCCESS"));
                        continue;
                    }
                    Log.d((String)TAG, (String)("claimInterface " + i + " FAIL"));
                }
                UsbInterface dataIface = this.mDevice.getInterface(this.mDevice.getInterfaceCount() - 1);
                for (int i = 0; i < dataIface.getEndpointCount(); ++i) {
                    UsbEndpoint ep = dataIface.getEndpoint(i);
                    if (ep.getType() != 2) continue;
                    if (ep.getDirection() == 128) {
                        this.mReadEndpoint = ep;
                        continue;
                    }
                    this.mWriteEndpoint = ep;
                }
                this.initialize();
                this.setBaudRate(9600);
                opened = true;
            }
            finally {
                if (!opened) {
                    try {
                        this.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.mConnection == null) {
                throw new IOException("Already closed");
            }
            try {
                this.mConnection.close();
            }
            finally {
                this.mConnection = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] dest, int timeoutMillis) throws IOException {
            int numBytesRead;
            Object object = this.mReadBufferLock;
            synchronized (object) {
                int readAmt = Math.min(dest.length, this.mReadBuffer.length);
                numBytesRead = this.mConnection.bulkTransfer(this.mReadEndpoint, this.mReadBuffer, readAmt, timeoutMillis);
                if (numBytesRead < 0) {
                    return 0;
                }
                System.arraycopy(this.mReadBuffer, 0, dest, 0, numBytesRead);
            }
            return numBytesRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(byte[] src, int timeoutMillis) throws IOException {
            int offset;
            int amtWritten;
            for (offset = 0; offset < src.length; offset += amtWritten) {
                int writeLength;
                Object object = this.mWriteBufferLock;
                synchronized (object) {
                    byte[] writeBuffer;
                    writeLength = Math.min(src.length - offset, this.mWriteBuffer.length);
                    if (offset == 0) {
                        writeBuffer = src;
                    } else {
                        System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                        writeBuffer = this.mWriteBuffer;
                    }
                    amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, timeoutMillis);
                }
                if (amtWritten <= 0) {
                    throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
                }
                Log.d((String)TAG, (String)("Wrote amt=" + amtWritten + " attempted=" + writeLength));
            }
            return offset;
        }

        private int controlOut(int request, int value, int index) {
            int REQTYPE_HOST_TO_DEVICE = 65;
            return this.mConnection.controlTransfer(65, request, value, index, null, 0, 5000);
        }

        private int controlIn(int request, int value, int index, byte[] buffer) {
            int REQTYPE_HOST_TO_DEVICE = 192;
            return this.mConnection.controlTransfer(192, request, value, index, buffer, buffer.length, 5000);
        }

        private void checkState(String msg, int request, int value, int[] expected) throws IOException {
            byte[] buffer = new byte[expected.length];
            int ret = this.controlIn(request, value, 0, buffer);
            if (ret < 0) {
                throw new IOException("Faild send cmd [" + msg + "]");
            }
            if (ret != expected.length) {
                throw new IOException("Expected " + expected.length + " bytes, but get " + ret + " [" + msg + "]");
            }
            for (int i = 0; i < expected.length; ++i) {
                int current;
                if (expected[i] == -1 || expected[i] == (current = buffer[i] & 0xFF)) continue;
                throw new IOException("Expected 0x" + Integer.toHexString(expected[i]) + " bytes, but get 0x" + Integer.toHexString(current) + " [" + msg + "]");
            }
        }

        private void writeHandshakeByte() throws IOException {
            if (this.controlOut(164, ~((this.dtr ? 32 : 0) | (this.rts ? 64 : 0)), 0) < 0) {
                throw new IOException("Faild to set handshake byte");
            }
        }

        private void initialize() throws IOException {
            this.checkState("init #1", 95, 0, new int[]{-1, 0});
            if (this.controlOut(161, 0, 0) < 0) {
                throw new IOException("init failed! #2");
            }
            this.setBaudRate(9600);
            this.checkState("init #4", 149, 9496, new int[]{-1, 0});
            if (this.controlOut(154, 9496, 80) < 0) {
                throw new IOException("init failed! #5");
            }
            this.checkState("init #6", 149, 1798, new int[]{255, 238});
            if (this.controlOut(161, 20511, 55562) < 0) {
                throw new IOException("init failed! #7");
            }
            this.setBaudRate(9600);
            this.writeHandshakeByte();
            this.checkState("init #10", 149, 1798, new int[]{-1, 238});
        }

        private void setBaudRate(int baudRate) throws IOException {
            int[] baud = new int[]{2400, 55553, 56, 4800, 25602, 31, 9600, 45570, 19, 19200, 55554, 13, 38400, 25603, 10, 115200, 52227, 8};
            for (int i = 0; i < baud.length / 3; ++i) {
                if (baud[i * 3] != baudRate) continue;
                int ret = this.controlOut(154, 4882, baud[i * 3 + 1]);
                if (ret < 0) {
                    throw new IOException("Error setting baud rate. #1");
                }
                ret = this.controlOut(154, 3884, baud[i * 3 + 2]);
                if (ret < 0) {
                    throw new IOException("Error setting baud rate. #1");
                }
                return;
            }
            throw new IOException("Baud rate " + baudRate + " currently not supported");
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            this.setBaudRate(baudRate);
        }

        @Override
        public boolean getCD() throws IOException {
            return false;
        }

        @Override
        public boolean getCTS() throws IOException {
            return false;
        }

        @Override
        public boolean getDSR() throws IOException {
            return false;
        }

        @Override
        public boolean getDTR() throws IOException {
            return this.dtr;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            this.dtr = value;
            this.writeHandshakeByte();
        }

        @Override
        public boolean getRI() throws IOException {
            return false;
        }

        @Override
        public boolean getRTS() throws IOException {
            return this.rts;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            this.rts = value;
            this.writeHandshakeByte();
        }

        @Override
        public boolean purgeHwBuffers(boolean purgeReadBuffers, boolean purgeWriteBuffers) throws IOException {
            return true;
        }
    }
}

