/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;

abstract class CommonUsbSerialPort
implements UsbSerialPort {
    public static final int DEFAULT_READ_BUFFER_SIZE = 16384;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 16384;
    protected final UsbDevice mDevice;
    protected final int mPortNumber;
    protected UsbDeviceConnection mConnection = null;
    protected final Object mReadBufferLock = new Object();
    protected final Object mWriteBufferLock = new Object();
    protected byte[] mReadBuffer;
    protected byte[] mWriteBuffer;

    public CommonUsbSerialPort(UsbDevice device, int portNumber) {
        this.mDevice = device;
        this.mPortNumber = portNumber;
        this.mReadBuffer = new byte[16384];
        this.mWriteBuffer = new byte[16384];
    }

    public String toString() {
        return String.format("<%s device_name=%s device_id=%s port_number=%s>", this.getClass().getSimpleName(), this.mDevice.getDeviceName(), this.mDevice.getDeviceId(), this.mPortNumber);
    }

    public final UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public int getPortNumber() {
        return this.mPortNumber;
    }

    @Override
    public String getSerial() {
        return this.mConnection.getSerial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReadBufferSize(int bufferSize) {
        Object object = this.mReadBufferLock;
        synchronized (object) {
            if (bufferSize == this.mReadBuffer.length) {
                return;
            }
            this.mReadBuffer = new byte[bufferSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWriteBufferSize(int bufferSize) {
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            if (bufferSize == this.mWriteBuffer.length) {
                return;
            }
            this.mWriteBuffer = new byte[bufferSize];
        }
    }

    @Override
    public abstract void open(UsbDeviceConnection var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract int read(byte[] var1, int var2) throws IOException;

    @Override
    public abstract int write(byte[] var1, int var2) throws IOException;

    @Override
    public abstract void setParameters(int var1, int var2, int var3, int var4) throws IOException;

    @Override
    public abstract boolean getCD() throws IOException;

    @Override
    public abstract boolean getCTS() throws IOException;

    @Override
    public abstract boolean getDSR() throws IOException;

    @Override
    public abstract boolean getDTR() throws IOException;

    @Override
    public abstract void setDTR(boolean var1) throws IOException;

    @Override
    public abstract boolean getRI() throws IOException;

    @Override
    public abstract boolean getRTS() throws IOException;

    @Override
    public abstract void setRTS(boolean var1) throws IOException;

    @Override
    public boolean purgeHwBuffers(boolean flushReadBuffers, boolean flushWriteBuffers) throws IOException {
        return !flushReadBuffers && !flushWriteBuffers;
    }
}

