/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.util.Pair;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProbeTable {
    private final Map<Pair<Integer, Integer>, Class<? extends UsbSerialDriver>> mProbeTable = new LinkedHashMap<Pair<Integer, Integer>, Class<? extends UsbSerialDriver>>();

    public ProbeTable addProduct(int vendorId, int productId, Class<? extends UsbSerialDriver> driverClass) {
        this.mProbeTable.put((Pair<Integer, Integer>)Pair.create((Object)vendorId, (Object)productId), driverClass);
        return this;
    }

    ProbeTable addDriver(Class<? extends UsbSerialDriver> driverClass) {
        Map devices;
        Method method;
        try {
            method = driverClass.getMethod("getSupportedDevices", new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            devices = (Map)method.invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : devices.entrySet()) {
            int vendorId = (Integer)entry.getKey();
            for (int productId : (int[])entry.getValue()) {
                this.addProduct(vendorId, productId, driverClass);
            }
        }
        return this;
    }

    public Class<? extends UsbSerialDriver> findDriver(int vendorId, int productId) {
        Pair pair = Pair.create((Object)vendorId, (Object)productId);
        return this.mProbeTable.get(pair);
    }
}

