package ubaa.net.usbwebsocket;

import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;

import java.net.InetSocketAddress;

public class MainActivity extends Activity {


    WSServer ws = null;
    Arduino usb = null;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }


    @Override
    protected void onStart() {
        super.onStart();
        WebSocketInit();
        ArduinoInit();
    }

    @Override
    protected void onStop() {
        super.onStop();
        if ( usb!=null ) usb.close();
    }


    public void WebSocketInit()
    {
        InetSocketAddress inetSockAddress = new InetSocketAddress( "127.0.0.1", 8080 );
        ws = new WSServer( this, inetSockAddress );
        ws.start();
    }

    public void WebSocketLog( String msg )
    {
        TextView view = (TextView)findViewById(R.id.ws_log);
        view.setText( msg );
    }




    public void ArduinoInit()
    {
        usb = new Arduino( this );
    }

    public void ArduinoLog( String msg )
    {
        TextView view = (TextView)findViewById(R.id.usb_log);
        view.setText( msg );
    }

}
