
////////////////////////////////////////////////////////////////////////////////////////////////
// websocket server
// http://stackoverflow.com/questions/28099656/websocket-server-on-android
////////////////////////////////////////////////////////////////////////////////////////////////


package ubaa.net.usbwebsocket;


import android.app.Activity;
import android.util.Log;

import java.net.InetSocketAddress;

import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;



public class WSServer extends WebSocketServer
{

    MainActivity app;

    public WSServer( MainActivity app, InetSocketAddress address )
    {
        super(address);

        this.app = app;
        app.WebSocketLog( "bind server to " + address.toString() );
        Log.i( "[WSServer]", "bind server to " + address.toString() );
    }

    @Override
    public void onClose(WebSocket arg0, int arg1, String arg2, boolean arg3)
    {
        //app.WebSocketLog( "close connection with " + arg0.getRemoteSocketAddress() );
        Log.i( "[WSServer]",  "close connection with " + arg0.getRemoteSocketAddress() );
    }

    @Override
    public void onError(WebSocket arg0, Exception arg1)
    {
        //app.WebSocketLog( arg1.getLocalizedMessage() );
        Log.e( "[WSServer]", arg1.getLocalizedMessage() );
        Log.getStackTraceString(arg1);
    }

    @Override
    public void onMessage(WebSocket arg0, String arg1)
    {
        //app.WebSocketLog( "message: "+arg1 );
        Log.i( "[WSServer]","new message from :" + arg0.getRemoteSocketAddress() + ", message : " +arg1);
    }

    @Override
    public void onOpen(WebSocket arg0, ClientHandshake arg1)
    {
        //app.WebSocketLog( "open connection with " + arg0.getRemoteSocketAddress() );
        Log.i( "[WSServer]", "open connection with " + arg0.getRemoteSocketAddress() );
    }
}